<?php

namespace App\Http\Controllers\API;

use App\Models\Subscription;
use App\Http\Controllers\Controller;
use App\Http\Requests\SubscribeRequest;
use App\Models\SubscriptionPlan;
use App\Models\Transaction;
use App\Repositories\SubscriptionRepository;
use App\Http\Resources\SubscriptionResouorce;
use App\Http\Resources\SubscriptionPlanResource;
use App\Models\PaymentGateway;
use App\Repositories\SubscriptionPlanRepository;
use App\Services\PaymentService;
use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Checkout\Session;

class SubscriptionController extends Controller
{
    public function __construct(
        private PaymentService $paymentService
    ) {
    }
    public function index()
    {
        $subscriptionPlans = (new SubscriptionPlanRepository())->getAll();

        return $this->json('Subscription plan list', [
            'plans' => SubscriptionPlanResource::collection($subscriptionPlans)
        ]);
    }

     public function buySubscription(SubscribeRequest $request)
    {
        $user = auth()->user();

        $plan = (new SubscriptionRepository())->storeByRequest($request);


        $user = auth()->user();
        $amount = $plan->amount;

        $successUrl = route('payment.success');
        $cancelUrl  = route('payment.cancel');


        switch ($request->payment_method) {
            case 'stripe':

                $paymentMethod = PaymentGateway::where('name','stripe')->first();

                $publishedKey =json_decode($paymentMethod->config)->publishable_key;
                $secretKey = json_decode($paymentMethod->config)->secret_key;

                if (!$publishedKey || !$secretKey) {
                    return $this->json('Stripe credentials not configured.' ,[], 500);
                }

                Stripe::setApiKey($secretKey);

                try {
                    $callbackUrl = $successUrl . '?' . http_build_query([
                        'payment' => 'stripe',
                        'plan_id' => $request->plan_id,
                        'user_id' => $user->id
                    ]);

                    $session = Session::create([
                        'payment_method_types' => ['card'],
                        'line_items' => [[
                            'price_data' => [
                                'currency' => 'usd',
                                'product_data' => ['name' => 'Plan #' . $request->plan_id],
                                'unit_amount' => (int)($amount * 100),
                            ],
                            'quantity' => 1,
                        ]],
                        'mode' => 'payment',
                        'success_url' => $callbackUrl . '&session_id={CHECKOUT_SESSION_ID}',
                        'cancel_url' => $cancelUrl . '?payment=stripe',
                        'metadata' => [
                            'plan_id' => $request->plan_id,
                            'user_id' => $user->id,
                        ],
                    ]);

                      return $this->json('Redirecting to payment gateway.' ,[
                            'redirectUrl' => $session->url
                        ], 201);

                } catch (\Exception $e) {
                    return $this->json('Stripe error: ' . $e->getMessage() ,[], 500);
                }

            default:
               return $this->json('Redirecting to payment gateway.' ,[
                    'status' => 'error',
                    'message' => 'Invalid payment method'
                ], 400);
        }
    }


    // public function buySubscription(Request $request)
    // {
    //     $alreadyEnrolled = Subscription::hasSubscribed(auth()->user());

    //     if (!$alreadyEnrolled) {
    //         $getPlan = SubscriptionPlan::where('id', $request->plan_id)->first();
    //         $transactionIdentifier = substr(str_shuffle(str_repeat('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 16)), 0, 16);
    //         $transaction = Transaction::create([
    //             'transaction_id' => $transactionIdentifier,
    //             'user_id' => auth()->user()->id,
    //             'plan_id' => $getPlan->id,
    //             'payment_method' => $request->payment_gateway,
    //             'is_paid' => false
    //         ]);
    //         return $this->json('Transaction initiated', [
    //             'payment_webview_url' => route('payment', ['transaction_id' => $transaction->transaction_id]),
    //         ], 201);
    //     }
    //     return $this->json('You already have an active subscription', null, 400);
    // }

    public function paymentView(string $transaction_id)
    {
        $transaction = Transaction::query()->where('transaction_id', '=', $transaction_id)->first();

        if ($transaction) {
            $planDetails = SubscriptionPlan::query()->where('id', '=', $transaction->plan_id)->first();
            return $this->paymentService->processPayment($planDetails->amount, [
                'gateway' => $transaction->payment_method,
                'transaction_id' => base64_encode($transaction->transaction_id),
                'product' => [
                    'product' => $planDetails->name,
                    'price' => $planDetails->amount,
                ],
                'customer' => [
                    'name' => $transaction->user?->name ?? 'N/A',
                    'email' => $transaction->user?->email ?? 'N/A',
                    'phone' => $transaction->user?->phone ?? 'N/A',
                ]
            ]);
        }
        return $this->json('Transaction not found', null, 404);


    }

    public function myPlans()
    {
        $user = auth()->user();
        $subscriptions = $user->subscriptions()->where('is_paid', '=', 1)->get();

        return $this->json('My subscription plan list', [
            'subscriptions' => SubscriptionResouorce::collection($subscriptions)
        ]);
    }

    public function store(SubscribeRequest $request)
    {
        $user = auth()->user();
        $is_expired = Subscription::hasSubscribed($user);
        if ($is_expired) {
            return $this->json('subscription plan buy successfully');
        }

        $plan = (new SubscriptionRepository())->storeByRequest($request);
        return $this->json('subscription plan buy successfully', [
            'subscription' => SubscriptionResouorce::make($plan)
        ]);
    }
}
