<?php

namespace App\Http\Controllers;

use App\Models\PaymentGateway;
use App\Models\Subscription;
use App\Models\SubscriptionPlan;
use App\Models\Transaction;
use App\Models\User;
use App\Services\AamarPayment;
use App\Services\PaymentService;
use App\Services\PaypalPayment;
use App\Services\StripePayment;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    protected $paymentService;
    public function index()
    {
        return view('payment');
    }

    public function payment(Request $request)
    {
        $paymentService = (new PaymentService());

        $this->paymentService = $paymentService;
        $amount = 100;
        $data = $request->all();
        return $this->paymentService->processPayment($amount, $data);

    }

    public function paymentSuccess(Request $request, $transaction_id)
    {

        $success = (new PaypalPayment);
        return $success->paymentSuccess($request, $transaction_id);
    }

    public function paymentCancel()
    {
        $cancel = (new PaypalPayment());
        return $cancel->paymentCancel();
    }

    public function stripePaymentSuccess($transaction_id)
    {
        $success = (new StripePayment());
        return $success->paymentSuccess($transaction_id);
    }

    public function stripePaymentCancel()
    {
        $cancel = (new StripePayment());
        return $cancel->paymentCancel();
    }

    public function aamarpayPaymentSuccess(Request $request)
    {
        $success = (new AamarPayment());
        return $success->paymentSuccess($request);
    }

    public function aamarpayPaymentCancel()
    {
        $cancel = (new AamarPayment());
        return $cancel->paymentCancel();
    }

    public function aamarpayPaymentFail(Request $request)
    {
        $fail = (new AamarPayment());
        return $fail->paymentFail($request);
    }



      public function successPayment(Request $request)
    {
        $queryParameters = $request->query();
        $plan = SubscriptionPlan::find($queryParameters['plan_id']);
        $user = User::find($queryParameters['user_id']);

        $amount = $plan->amount;
        $paymentMethod = $queryParameters['payment'];

        switch ($paymentMethod) {
            case 'stripe':
                $paymentMethod = PaymentGateway::where('name','stripe')->first();
                $secret_key = json_decode($paymentMethod->config)->secret_key;

                \Stripe\Stripe::setApiKey($secret_key);

                $sessionId = $queryParameters['session_id'];

                $session = \Stripe\Checkout\Session::retrieve($sessionId);

                if ($session->payment_status === 'paid') {

                       foreach ($user->subscriptions as $subscription) {

                            $subscriptionPlanId = $subscription->subscription_plan_id;
                            if ($subscriptionPlanId == $plan->id) {
                                $subscription->update([
                                    'is_paid' => true
                                ]);
                                Transaction::create([
                                    'user_id' => $user->id,
                                    'plan_id' => $plan->id,
                                    'amount' => $amount,
                                    'is_paid' => true,
                                    'payment_method' => 'stripe',
                                    'transaction_id' => $session->id
                                ]);


                        }
                        }
                    return to_route('payment.success.response');
                }
                return to_route('payment.cancel');

            default:
            return $this->json(message: 'Payment not completed');
        }
    }

    public function success()
    {
        return $this->json('Payment done successfully.');

    }



    public function cancelPayment()
    {

        return $this->json('Payment not completed.');

    }
}
