<?php

use App\Models\Albam;
use App\Models\AlbamCategory;
use App\Models\Category;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create((new AlbamCategory())->getTable(), function (Blueprint $table) {
            $table->id();
            $table->foreignId('albam_id')->constrained((new Albam())->getTable());
            $table->foreignId('category_id')->constrained((new Category())->getTable());
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists((new AlbamCategory())->getTable());
    }
};
